<?php
$mc_brand = defined('MOORES_BRAND') ? MOORES_BRAND : '';
$mc_byline = defined('MOORES_BYLINE') ? MOORES_BYLINE : '';
$mc_location = defined('MOORES_LOCATION') ? MOORES_LOCATION : '';
$mc_phone = defined('MOORES_PHONE') ? MOORES_PHONE : '';
$mc_hours_weekdays = defined('MOORES_HOURS_WEEKDAYS') ? MOORES_HOURS_WEEKDAYS : '';
$mc_hours_saturday = defined('MOORES_HOURS_SATURDAY') ? MOORES_HOURS_SATURDAY : '';
?>

<footer class="footer" id="contact">
	<div class="container-wide">
		<hr class="sep">
		<small><strong><?php echo esc_html($mc_brand); ?></strong> - <?php echo esc_html($mc_location); ?></small>
		<small>Phone: <?php echo esc_html($mc_phone); ?> | Weekdays: <?php echo esc_html($mc_hours_weekdays); ?> | Sat: <?php echo esc_html($mc_hours_saturday); ?></small>
		<small>© <?php echo date('Y'); ?> <?php echo esc_html($mc_brand); ?> - Powered by <?php echo esc_html($mc_byline); ?></small>
	</div>
</footer>

<div class="mc-auth-modal" id="mc-settings-modal" hidden>
	<div class="mc-auth-backdrop" data-settings-close></div>
	<div class="mc-auth-panel" role="dialog" aria-modal="true" aria-labelledby="mc-settings-title">
		<button class="mc-auth-close" type="button" data-settings-close aria-label="Close">×</button>
		<h3 id="mc-settings-title">Account Settings</h3>
		<p class="mc-auth-sub">Manage your account details and access options.</p>

		<div class="mc-settings-grid">
			<div class="mc-settings-row">
				<span>Name</span>
				<strong data-settings-name>—</strong>
			</div>
			<div class="mc-settings-row">
				<span>Email</span>
				<strong data-settings-email>—</strong>
			</div>
		</div>

		<div class="mc-auth-message" data-settings-message aria-live="polite"></div>

		<div class="mc-auth-actions">
			<button class="btn btn-outline" type="button" data-settings-reset>Send password reset</button>
			<a class="btn btn-primary" href="#" data-settings-portal hidden>Open portal</a>
		</div>
	</div>
</div>

<?php
	$mc_phone_raw = $mc_phone ? preg_replace('/[^0-9+]/', '', $mc_phone) : '';
?>
<script>
(() => {
	const header = document.querySelector('.mc-header');
	const toggle = document.querySelector('.mc-nav-toggle');
	if (!header || !toggle) return;
	let lastY = window.scrollY || 0;
	let ticking = false;
	const accountToggle = header.querySelector('.mc-account-toggle');
	const accountWrap = header.querySelector('.mc-account');
	const accountMenu = header.querySelector('.mc-account-menu');
	const accountName = accountMenu ? accountMenu.querySelector('[data-account-name]') : null;
	const accountEmail = accountMenu ? accountMenu.querySelector('[data-account-email]') : null;
	const loginBtn = accountMenu ? accountMenu.querySelector('[data-account-login]') : null;
	const settingsBtn = accountMenu ? accountMenu.querySelector('[data-account-settings]') : null;
	const logoutBtn = accountMenu ? accountMenu.querySelector('[data-account-logout]') : null;
	const clientLink = accountMenu ? accountMenu.querySelector('[data-account-client]') : null;
	const staffLink = accountMenu ? accountMenu.querySelector('[data-account-staff]') : null;
	const avatarImgs = header.querySelectorAll('[data-account-avatar]');
	const defaultAvatar = accountToggle ? (accountToggle.dataset.defaultAvatar || '') : '';
	const defaultAvatarFallback = accountToggle ? (accountToggle.dataset.defaultAvatarFallback || '') : '';
	const portalUrl = accountMenu ? (accountMenu.dataset.portalUrl || '') : '';
	const staffPortalUrl = accountMenu ? (accountMenu.dataset.staffPortalUrl || '') : '';
	const settingsModal = document.getElementById('mc-settings-modal');
	const settingsName = settingsModal ? settingsModal.querySelector('[data-settings-name]') : null;
	const settingsEmail = settingsModal ? settingsModal.querySelector('[data-settings-email]') : null;
	const settingsMessage = settingsModal ? settingsModal.querySelector('[data-settings-message]') : null;
	const settingsReset = settingsModal ? settingsModal.querySelector('[data-settings-reset]') : null;
	const settingsPortal = settingsModal ? settingsModal.querySelector('[data-settings-portal]') : null;
	const settingsClosers = settingsModal ? settingsModal.querySelectorAll('[data-settings-close]') : [];
	const settingsAjaxUrl = accountMenu ? (accountMenu.dataset.ajaxUrl || '') : '';
	const settingsNonce = accountMenu ? (accountMenu.dataset.nonce || '') : '';
	let guestAvatarState = { url: '', status: 'idle' };
	let guestAvatarPromise = null;

	const closeNav = () => {
		header.classList.remove('nav-open');
		toggle.setAttribute('aria-expanded', 'false');
		toggle.setAttribute('aria-label', 'Open menu');
	};

	const closeAccountMenu = () => {
		if (!accountMenu || !accountToggle) return;
		accountMenu.hidden = true;
		accountToggle.setAttribute('aria-expanded', 'false');
		accountToggle.setAttribute('aria-label', 'Open account menu');
	};

	const closeSettings = () => {
		if (!settingsModal) return;
		settingsModal.hidden = true;
		document.body.classList.remove('mc-auth-open');
	};

	const openAccountMenu = () => {
		if (!accountMenu || !accountToggle) return;
		accountMenu.hidden = false;
		accountToggle.setAttribute('aria-expanded', 'true');
		accountToggle.setAttribute('aria-label', 'Close account menu');
	};

	toggle.addEventListener('click', () => {
		const isOpen = header.classList.toggle('nav-open');
		toggle.setAttribute('aria-expanded', isOpen ? 'true' : 'false');
		toggle.setAttribute('aria-label', isOpen ? 'Close menu' : 'Open menu');
		closeAccountMenu();
	});

	header.querySelectorAll('.mc-menu a').forEach((link) => {
		link.addEventListener('click', closeNav);
	});

	document.addEventListener('click', (event) => {
		if (header.classList.contains('nav-open') && !header.contains(event.target)) {
			closeNav();
		}
		if (accountMenu && !accountMenu.hidden) {
			if (accountToggle && (accountToggle.contains(event.target) || accountMenu.contains(event.target))) {
				return;
			}
			closeAccountMenu();
		}
	});

	if (accountToggle && accountMenu) {
		accountToggle.addEventListener('click', (event) => {
			event.preventDefault();
			if (accountMenu.hidden) {
				openAccountMenu();
				closeNav();
			} else {
				closeAccountMenu();
			}
		});
		accountMenu.addEventListener('click', (event) => {
			if (event.target.closest('.mc-account-item')) {
				closeAccountMenu();
			}
		});
	}

	if (settingsBtn) {
		settingsBtn.addEventListener('click', (event) => {
			event.preventDefault();
			openSettings();
		});
	}

	if (settingsReset) {
		settingsReset.addEventListener('click', async (event) => {
			event.preventDefault();
			const packet = getStoredPacket();
			const email = getDisplayEmail(packet);
			if (!email) {
				if (settingsMessage) settingsMessage.textContent = 'Email address not available.';
				return;
			}
			if (!settingsAjaxUrl) {
				if (settingsMessage) settingsMessage.textContent = 'Reset service is not available.';
				return;
			}
			settingsReset.disabled = true;
			if (settingsMessage) settingsMessage.textContent = 'Sending password reset...';
			try {
				const payload = new URLSearchParams();
				payload.set('action', 'moores_sentra_password_reset');
				payload.set('email', email);
				if (settingsNonce) payload.set('nonce', settingsNonce);
				const res = await fetch(settingsAjaxUrl, {
					method: 'POST',
					headers: { 'Content-Type': 'application/x-www-form-urlencoded; charset=UTF-8' },
					body: payload.toString()
				});
				const data = await res.json();
				if (data?.success) {
					if (settingsMessage) settingsMessage.textContent = 'Password reset sent. Check your email.';
				} else {
					const message = data?.data?.message || data?.message || 'Password reset failed.';
					if (settingsMessage) settingsMessage.textContent = message;
				}
			} catch (err) {
				if (settingsMessage) settingsMessage.textContent = 'Password reset failed.';
			} finally {
				settingsReset.disabled = false;
			}
		});
	}

	settingsClosers.forEach((btn) => {
		btn.addEventListener('click', (event) => {
			event.preventDefault();
			closeSettings();
		});
	});

	window.addEventListener('keydown', (event) => {
		if (event.key === 'Escape') {
			closeAccountMenu();
			closeSettings();
		}
	});

	const getStoredPacket = () => {
		try {
			const raw = localStorage.getItem('sentra_auth_packet');
			if (!raw) return null;
			return JSON.parse(raw);
		} catch (e) {
			return null;
		}
	};

	const isPacketValid = (packet) => {
		if (!packet || !packet.expires_at) return false;
		const now = Math.floor(Date.now() / 1000);
		return packet.expires_at > now;
	};

	const hasStaffBadge = (packet) => {
		if (!packet) return false;
		if (packet.staff_checked !== true) return false;
		if (packet.is_staff === true || packet.is_staff === 1 || packet.is_staff === '1') return true;
		return false;
	};

	const pickString = (...values) => {
		for (const value of values) {
			if (typeof value === 'string' && value.trim()) return value.trim();
		}
		return '';
	};

	const getAvatarFromPacket = (packet) => {
		if (!packet || typeof packet !== 'object') return '';
		const user = packet.user || {};
		return pickString(
			packet.avatar_url,
			packet.avatar,
			packet.photo_url,
			packet.profile_photo,
			packet.profile_photo_url,
			packet.photoURL,
			packet.avatarUrl,
			packet.picture,
			packet.image,
			user.avatar_url,
			user.avatar,
			user.photo_url,
			user.profile_photo,
			user.profile_photo_url,
			user.photoURL,
			user.avatarUrl,
			user.picture,
			user.image
		);
	};

	const isValidAvatarUrl = (value) => {
		if (typeof value !== 'string') return false;
		const trimmed = value.trim();
		if (!trimmed) return false;
		if (trimmed === 'null' || trimmed === 'undefined') return false;
		if (/^data:image\//i.test(trimmed)) return true;
		if (/^https?:\/\//i.test(trimmed)) return true;
		if (trimmed.startsWith('/')) return true;
		return false;
	};

	const loadImage = (url) => new Promise((resolve) => {
		if (!url) return resolve(false);
		const img = new Image();
		img.onload = () => resolve(true);
		img.onerror = () => resolve(false);
		img.src = url;
	});

	const applyGuestAvatar = (url) => {
		if (!accountWrap) return;
		accountWrap.style.setProperty('--guest-avatar', `url("${url}")`);
		accountWrap.classList.add('has-guest-avatar');
	};

	const clearGuestAvatar = () => {
		if (!accountWrap) return;
		accountWrap.classList.remove('has-guest-avatar');
		accountWrap.style.removeProperty('--guest-avatar');
	};

	const ensureGuestAvatar = (url, fallbackUrl = '') => {
		if (!accountWrap) return;
		const primary = isValidAvatarUrl(url) ? url : '';
		const fallback = isValidAvatarUrl(fallbackUrl) ? fallbackUrl : '';
		if (!primary && !fallback) {
			clearGuestAvatar();
			return;
		}
		const target = primary || fallback;
		if (guestAvatarState.url === target && guestAvatarState.status === 'loaded') {
			applyGuestAvatar(target);
			return;
		}
		if (guestAvatarState.url === target && guestAvatarState.status === 'failed') {
			clearGuestAvatar();
			return;
		}
		guestAvatarState = { url: target, status: 'loading' };
		guestAvatarPromise = loadImage(target).then((ok) => {
			if (guestAvatarState.url !== target) return ok;
			if (ok) {
				guestAvatarState.status = 'loaded';
				applyGuestAvatar(target);
				return ok;
			}
			if (fallback && fallback !== target) {
				guestAvatarState = { url: fallback, status: 'loading' };
				return loadImage(fallback).then((ok2) => {
					if (guestAvatarState.url !== fallback) return ok2;
					guestAvatarState.status = ok2 ? 'loaded' : 'failed';
					if (ok2) {
						applyGuestAvatar(fallback);
					} else {
						clearGuestAvatar();
					}
					return ok2;
				});
			}
			guestAvatarState.status = 'failed';
			clearGuestAvatar();
			return ok;
		});
	};

	const getDisplayName = (packet) => {
		if (!packet || typeof packet !== 'object') return 'Guest';
		return pickString(packet.name, packet.full_name, packet.username, packet.email) || 'Guest';
	};

	const getDisplayEmail = (packet) => {
		if (!packet || typeof packet !== 'object') return '';
		return pickString(packet.email, packet.username);
	};

	const openSettings = () => {
		if (!settingsModal) return;
		const packet = getStoredPacket();
		if (!isPacketValid(packet)) return;
		if (settingsName) settingsName.textContent = getDisplayName(packet);
		if (settingsEmail) settingsEmail.textContent = getDisplayEmail(packet) || 'Signed in';
		if (settingsMessage) settingsMessage.textContent = '';
		if (settingsPortal) {
			const isStaff = hasStaffBadge(packet);
			const target = isStaff ? staffPortalUrl : portalUrl;
			if (target) {
				settingsPortal.hidden = false;
				settingsPortal.setAttribute('href', target);
				settingsPortal.textContent = isStaff ? 'Open Staff Portal' : 'Open Client Portal';
			} else {
				settingsPortal.hidden = true;
			}
		}
		settingsModal.hidden = false;
		document.body.classList.add('mc-auth-open');
		closeNav();
		closeAccountMenu();
	};

	const applyAccountState = (packet) => {
		const isValid = isPacketValid(packet);
		const isStaff = isValid && hasStaffBadge(packet);
		if (accountName) accountName.textContent = isValid ? getDisplayName(packet) : 'Guest';
		if (accountEmail) {
			accountEmail.textContent = isValid
				? (getDisplayEmail(packet) || 'Signed in')
				: 'Sign in to access your portal.';
		}

		if (loginBtn) loginBtn.hidden = isValid;
		if (loginBtn) loginBtn.textContent = 'Sign in';
		if (settingsBtn) settingsBtn.hidden = !isValid;
		if (settingsBtn) settingsBtn.textContent = 'Account settings';
		if (logoutBtn) logoutBtn.hidden = !isValid;
		if (logoutBtn) logoutBtn.textContent = 'Sign out';

		if (clientLink) {
			const showClient = isValid && !!portalUrl;
			clientLink.hidden = !showClient;
			if (showClient) {
				clientLink.setAttribute('href', portalUrl);
				clientLink.textContent = 'Client portal';
			}
		}
		if (staffLink) {
			const showStaff = isValid && isStaff && !!staffPortalUrl;
			staffLink.hidden = !showStaff;
			if (showStaff) {
				staffLink.setAttribute('href', staffPortalUrl);
				staffLink.textContent = 'Staff portal';
			}
		}

		const avatar = getAvatarFromPacket(packet);
		const guestAvatar = isValidAvatarUrl(defaultAvatar) ? defaultAvatar : '';
		const guestFallback = isValidAvatarUrl(defaultAvatarFallback) ? defaultAvatarFallback : '';
		const hasUserAvatar = isValid && isValidAvatarUrl(avatar);
		const useGuestAvatar = !isValid && (!!guestAvatar || !!guestFallback);
		if (accountWrap) {
			accountWrap.classList.toggle('has-avatar', hasUserAvatar);
		}
		if (useGuestAvatar) {
			ensureGuestAvatar(guestAvatar, guestFallback);
		} else {
			clearGuestAvatar();
		}
		avatarImgs.forEach((img) => {
			if (!img) return;
			if (hasUserAvatar) {
				img.src = avatar;
				img.hidden = false;
				img.onerror = () => {
					img.hidden = true;
					img.removeAttribute('src');
					if (accountWrap) accountWrap.classList.remove('has-avatar');
				};
			} else {
				img.removeAttribute('src');
				img.hidden = true;
			}
		});

		document.body.classList.toggle('mc-authenticated', isValid);
		document.body.classList.toggle('mc-staff', isStaff);
		document.querySelectorAll('[data-auth-open]').forEach(btn => {
			if (btn.closest('.mc-account-menu')) return;
			btn.textContent = isValid ? 'My Account' : 'Client Login';
		});
	};

	const clearAuthState = () => {
		try { localStorage.removeItem('sentra_auth_packet'); } catch (e) {}
		applyAccountState(null);
		try {
			window.dispatchEvent(new CustomEvent('sentra-auth-updated', {
				detail: { packet: null, isValid: false, isStaff: false }
			}));
		} catch (e) {}
	};

	if (logoutBtn) {
		logoutBtn.addEventListener('click', (event) => {
			event.preventDefault();
			clearAuthState();
		});
	}

	const syncAuthState = () => {
		applyAccountState(getStoredPacket());
	};

	window.addEventListener('sentra-auth-updated', (event) => {
		const packet = event && event.detail ? (event.detail.packet || null) : null;
		applyAccountState(packet || getStoredPacket());
	});
	window.addEventListener('focus', syncAuthState);
	document.addEventListener('visibilitychange', () => {
		if (!document.hidden) syncAuthState();
	});
	syncAuthState();

	const onScroll = () => {
		if (ticking) return;
		ticking = true;
		requestAnimationFrame(() => {
			const currentY = window.scrollY || 0;
			const delta = currentY - lastY;
			const isNavOpen = header.classList.contains('nav-open');
			header.classList.toggle('mc-header-scrolled', currentY > 10);
			if (currentY < 40 || isNavOpen) {
				header.classList.remove('mc-header-hidden');
			} else if (Math.abs(delta) > 8) {
				if (delta > 0 && currentY > 120) {
					header.classList.add('mc-header-hidden');
					closeNav();
				} else {
					header.classList.remove('mc-header-hidden');
				}
			}
			lastY = currentY;
			ticking = false;
		});
	};
	window.addEventListener('scroll', onScroll, { passive: true });
})();
</script>

<?php wp_footer(); ?>
</body>
</html>
